#define _GNU_SOURCE

#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "headers/includes.h"
#include "headers/rand.h"
#include "headers/xor.h"
#include "headers/util.h"
static uint32_t x, y, z, w;

void rand_init(void)
{
    x = time(NULL);
    y = getpid() ^ getppid();
    z = clock();
    w = z ^ y;
}
uint32_t rand_next(void)
{
    uint32_t t = x;
    t ^= t << 11;
    t ^= t >> 8;
    x = y; y = z; z = w;
    w ^= w >> 19;
    w ^= t;
    return w;
}

void rand_alpha_str(uint8_t *str, int len)
{
    table_unlock_val(XOR_RANDOM);
    char alpha_set[64];
    strcpy(alpha_set,table_retrieve_val(XOR_RANDOM, NULL));
    while(len--)
        *str++ = alpha_set[rand_next() % util_strlen(alpha_set)];
    table_lock_val(XOR_RANDOM);
}

void rand_str(char *str, int len) 
{
    while (len > 0)
    {
        if (len >= 4)
        {
            *((uint32_t *)str) = rand_next();
            str += sizeof (uint32_t);
            len -= sizeof (uint32_t);
        }
        else if (len >= 2)
        {
            *((uint16_t *)str) = rand_next() & 0xFFFF;
            str += sizeof (uint16_t);
            len -= sizeof (uint16_t);
        }
        else
        {
            *str++ = rand_next() & 0xFF;
            len--;
        }
    }
}



